<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/

require_once APPPATH.'libraries/attachment.php';

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class Word_attachment extends Attachment{

	/**
	* Creates a PDF version of this Word attachment and returns it as an attachment object.
	* @return PDF_attachment
	*/
	public function to_pdf(){
		if(!USE_DOC_TO_PDF_CONVERSION_PROCESS) return false;
		
		$CI = get_instance();

		// add attachement to cache.
		if(!$CI->user->add_file_to_system_cache($this->name, $this->binary_string)){
			$this->error->warning('Unable to convert '.$this->describe().' to PDF: could not write '.$this->name.' to system cache');
		}

		//create pdf output and reference filename
		$pdf_name = replace_last_with($this->extension, 'pdf', $this->name);
		$pdf_path = $CI->user->system_cache().$pdf_name;
		
		//use preexisting method in conversion engine to convert word attachments to pdf
		if(!class_exists('COM')) return $this->error->warning('Unable to convert '.$this->describe().' to PDF: COM library is not available'); //fail gracefully if COM is not available on this server
		try{
			$helper = new COM("pdfConversion.Class1");
			/*$doc = */ $helper->ConvertToPDF($CI->user->system_cache().$this->name, $pdf_path);
	#		$doc = null; //generally don't need to do this - PHP garbage collection will take care of it.  If this is a weird case in which you need to for high-memory operations, consider using unset($doc) instead. -- MG 2014-11-18
		}catch(Exception $e){
			return $this->error->warning('Unable to convert '.$this->describe().' to PDF: '.$e->getMessage());		
		}

		if(!file_exists($pdf_path)) 
			return $this->error->warning('Unable to convert '.$this->describe().' to PDF: '.$pdf_path.' was not created successfully.');

		return PDF_attachment::create($pdf_name, file_get_contents($pdf_path), array('directory' => $CI->user->system_cache()));
	}

	public function view(){
		if(!USE_DOC_TO_PDF_CONVERSION_PROCESS) return $this->download();
		
		//convert this Word document to PDF
		$pdf = $this->to_pdf();
		
		//if the conversion worked, display the PDF
		if(is_a($pdf, 'PDF_attachment'))
			return $pdf->view();
		
		//default to downloading the document if we ran into problems.
		return $this->download();
	}

/////////////////////
// STATIC FUNCTIONS
/////////////////////

	public static function create($name, $binary_string, $more_values = array()){
		if(empty($binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()), $name);
		if(!static::matches_file($name, $binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()), $name);
		return new Word_attachment(array_merge(compact('name', 'binary_string'), $more_values));
	}

	public static function matches_file($name, $binary_string){
		if(!parent::matches_file($name, $binary_string)) return false;
		return in_array(strtolower(pathinfo($name, PATHINFO_EXTENSION)), array('doc', 'docx'));
	}

}
?>